/* Este programa recibe 'n' datos por el UART, y luego los transmite tras presionar un pulsador
 * ubicado en el pin P0.8 y activo por bajo.
 */
#include "communication.h"
#include "uart.h"

#define ISR_ENTRY() asm volatile(" sub   lr, lr,#4\n" \
                                 " stmdb sp!,{lr}\n"\
                                 " stmdb sp!,{r0-r7,ip}")
                                
#define ISR_EXIT()  asm volatile(" ldmia sp!,{r0-r7,ip}\n" \
                                 " ldmia sp!,{pc}^")

void irq_handler (void) __attribute__((naked));

int main(void)
{
	SCB_VPBDIV = 1;				        	    // Frec de los Perisfericos 60MHz	
	unsigned char buf[50] = {0};

	int trucha=0;
  int i;

	com_init();

  while(1)
  {

    if(IOPIN0 & (1<<8))                // Pulsador, activo por bajo, para iniciar la tranmisin.
    { 
      for(i=0;i<10000;i++);
      if(IOPIN0 & (1<<8))
      { 
        trucha = receive_packet(buf);  // Lectura del buffer de recepcion
        if(trucha!=0)
        {
          send_packet(buf,trucha);
          trucha=0;
        }
      }
    }
  }

	return 0;
}

void irq_handler (void)
{
  ISR_ENTRY();
	irq_communication();
	VICIntEnClear = 0x28000;
	VICIntEnable = 0x28000;
 	VICVectAddr = 0x00;		    		// Fin de una interrupcion.
  ISR_EXIT();
}
