/* led.c */
#include "led.h"
#include "lpc2114.h"

void led_init()
{
	/* Define the LED pins P1.[16..23] as output */
	IODIR1 = 0x00FF0000;

	/* Clear all pins */
	IOCLR1 = 0x00FF0000;
}

void led(unsigned long val)
{
	/* LEDs off */
	IOCLR1 = (~val & 0xFF) << 16;

	/* LEDs on */
	IOSET1 =  (val & 0xFF) << 16;
}

void led_set(unsigned long set)
{
	IOSET1 =  (set & 0xFF) << 16;
}


void led_clr(unsigned long clr)
{
	IOCLR1 = (clr & 0xFF) << 16;
}


