/* Startup propio */

    .global main
    .global _start
	
    /* Symbols defined by the linker script */
    /*.global _etext*/
    .global _data
    .global _edata
    .global _bss
    .global _ebss
    
    .text
    .arm

/* ----------------------------------------------------------------
 * Exception vectors
 * ----------------------------------------------------------------
 */
_start:
    b reset  /* reset */
    b loop   /* undefined instruction */
    b loop   /* software interrupt */
    b loop   /* prefetch abort */
    b loop   /* data abort */
    nop      /* reserved for the bootloader checksum */
    b loop   /* VicVectAddr */
    b loop
  

/* ----------------------------------------------------------------
 * LPC21xx PLL setup
 * ----------------------------------------------------------------
 */
reset:
  
/* ----------------------------------------------------------------
 * C runtime setup
 * ----------------------------------------------------------------
 */
runtime_init:
    /* Copy .data */
    ldr r0, data_source
    ldr r1, data_start
    ldr r2, data_end
copy_data:
    cmp   r1, r2
    ldrne r3, [r0], #4
    strne r3, [r1], #4
    bne   copy_data
	
    /* Clear .bss */
    ldr r0, =0
    ldr r1, bss_start
    ldr r2, bss_end
clear_bss:
    cmp   r1, r2
    strne r0, [r1], #4
    bne   clear_bss

    /* Jump to main */
    bl  main

/* Catch return from main */
loop:   b   loop


/* ----------------------------------------------------------------
 * 32-bit constants (and storage)
 * ----------------------------------------------------------------
 *
 * These 32-bit constants are used in ldr statements.
 */

/* LPC SRAM starts at 0x40000000, and there is 16Kb = 4000h */ 
STACK_START:	.word   0x40004000

/* Linker symbols */
data_source:    .word   _etext
data_start:     .word   _data
data_end:       .word   _edata
bss_start:      .word   _bss
bss_end:        .word   _ebss


    .end
