#ifndef __ROMAA_PARAMS_H
#define __ROMAA_PARAMS_H


/**************************************************** 
Periodo de repeticion de las tareas (ms) por defecto 
*****************************************************/
#define DEFAULT_T_PID_LOOP	  20    
#define DEFAULT_T_ODOM            25   
#define DEFAULT_T_COMM            30  
#define DEFAULT_T_LOGGING         50      
#define DEFAULT_T_RTOS_ALIVE      100 

/********************************** 
* Constantes de los controles PID
***********************************/
#define V_PID_KP  5.0
#define V_PID_KI  1.0
#define V_PID_KD  0.0
#define VW_PID_KP 0.0
#define VW_PID_KI 0.0
#define VW_PID_KD 0.0

/************************* 
Encoders y velocidad cero 
**************************/
#define T_ZERO_SPEED 500	// Tiempo para determinar velocidad cero en ms

#define        N_PCLK_TO_W \
  ((2 * M_PI)/(ENCODER_PULSE_PER_REVOLUTION * MOTOR_REDUCTION * ROMAA_TIMEBASE))

#define        WHEEL_DIST_RESOLUTION \
  ((M_PI * NOM_WHEEL_DIAMETER)/(ENCODER_PULSE_PER_REVOLUTION * MOTOR_REDUCTION))


/****************************** 
     ADC - Nivel de Batería
*******************************/
#define ADC_CONV_CTE	        481.08 // Cte para conversión de voltaje dependiente del
					                   // divisor resisitivo usado y sus tolerancias
#define ADC_BATTERY_MAX_VOLTAGE	12.00  // Voltaje de la batería para la cuál se midio
					                   // la conversión ADC_CONV_CTE 
#define ADC_AVERAGE_SAMPLES     60     // Cantidad de muestras a promediar
#define ADC_COUNTER_SAMPLING    10     // Cantidad de repeticiones de la tarea
                                       // antes de hacer una  nueva medición
#define ADC_CLOCK_DIVISOR       15     // Divisor para el clock de los periféricos

/* Niveles de batería de alerta */
#define BATTERY_LEVEL_HIGH	12.32	// 70% de carga de batería
#define BATTERY_LEVEL_LOW	11.90	// 40% de carga de batería

// defines of RoMAA geometry
#define		ROMAA_BODY_WIDTH		0.520
#define		ROMAA_BODY_LENGHT		0.570
#define		ROMAA_BODY_HIGH			0.200



#ifndef ROMAA_II

  /*** RoMAA prototype ***/
  #define		ENCODER_PULSE_PER_REVOLUTION 100
  #define		MOTOR_REDUCTION 	     16
  // defines odometric parameters
  #define		NOM_WHEELBASE_RIGHT          0.450
  #define		NOM_WHEELBASE_LEFT           0.450
  #define               NOM_WHEELBASE               ((NOM_WHEELBASE_RIGHT + \
                                                      NOM_WHEELBASE_LEFT) / 2)
  #define		NOM_WHEEL_DIAMETER_RIGHT     0.1472
  #define		NOM_WHEEL_DIAMETER_LEFT      0.1472
  #define               NOM_WHEEL_DIAMETER          ((NOM_WHEEL_DIAMETER_RIGHT + \
                                                      NOM_WHEEL_DIAMETER_LEFT) / 2)
  #define               NOM_WHEEL_RADIOUS           ( NOM_WHEEL_DIAMETER / 2)

#else

  /*** RoMAA-II ***/
  #define		ENCODER_PULSE_PER_REVOLUTION 1000
  #define		MOTOR_REDUCTION 	     1
  // defines odometric parameters
  #define		NOM_WHEELBASE_RIGHT          0.444
  #define		NOM_WHEELBASE_LEFT           0.444
  #define               NOM_WHEELBASE               ((NOM_WHEELBASE_RIGHT + \
                                                      NOM_WHEELBASE_LEFT) / 2)
  #define		NOM_WHEEL_DIAMETER_RIGHT     0.139
  #define		NOM_WHEEL_DIAMETER_LEFT      0.139
  #define               NOM_WHEEL_DIAMETER          ((NOM_WHEEL_DIAMETER_RIGHT + \
                                                      NOM_WHEEL_DIAMETER_LEFT) / 2)
  #define               NOM_WHEEL_RADIOUS           ( NOM_WHEEL_DIAMETER / 2)



#endif  // Fin de compilacion condicional para motor loop

#endif /* __ROMAA_PARAMS_H */
