import numpy as np
import matplotlib
matplotlib.use('TkAgg')
#matplotlib.use('Agg')
#matplotlib.use('WX')
import matplotlib.pyplot as plt
from mpl_toolkits.mplot3d import Axes3D 
color = ['r','g','b','y','brown','c','orange','k','m','black','purple','indigo','lime']
#----------------------------------------------
def calc_coord(H):
	pts = np.array([[6,5,15,1],
		[6,-5,15,1],
		[-6,-5,15,1],
		[-6,5,15,1],
		[6,5,15,1],
		[0,0,0,1]])
	P3d = pts
	for i in range(pts.shape[0]):
		P3d[i] = np.dot(pts[i],H.T)
		P3d[i] = P3d[i]/P3d[i,3]
	p = P3d[:pts.shape[0]-1,:3]
	c = P3d[pts.shape[0]-1,:3]
	return p,c

def set_limits(lim,ax):
	for i in range(3):
		if lim[0,0]>lim[i,0]:
			lim[0,0] = lim[i,0]
		if lim[0,1]<lim[i,1]:
			lim[0,1] = lim[i,1]
	ax.set_xlim3d(lim[0,0],lim[0,1])
	ax.set_ylim3d(lim[0,0],lim[0,1])
	ax.set_zlim3d(lim[0,0],lim[0,1])	
	return ax


def cam_draw(ax,H,nom):
	global color
	k = np.random.randint(len(color))
	p,c = calc_coord(H)
	x,y,z = p[:,0],p[:,1],p[:,2]
	ax.plot(x,y,z,c=color[k],label=nom)
	ax.legend()
	for i in range(len(p)):
		x = np.array([p[i,0],c[0]])
		y = np.array([p[i,1],c[1]])
		z = np.array([p[i,2],c[2]])
		ax.plot(x,y,z,c=color[k])
	color = color[:k]+color[k+1:]
	return ax
#-------  Ejemplo  --------------
#H1 = np.array([[1,0,0,0],
#	[0,1,0,35],
#	[0,0,1,0],
#	[0,0,0,1]])
#ax = cam_draw(ax,H1,"cam0")
#plt.show()
