import pylab as pl
from scipy import ndimage 

im = ndimage.imread("romaa_gris.jpg")
pl.figure()
pl.gray()
pl.imshow(im)

H = pl.array([[1.4, 0.05,-300],
              [0.5, 1.5, -500],
	      [0,   0,    1]])
A = H[:2,:2]
t = ( H[0,2], H[1,2] )

warped_im = ndimage.affine_transform(im, A, t)

pl.figure()
pl.gray()
pl.imshow(warped_im)

pl.show()
