# coding: utf-8

import pylab as pl
from scipy import ndimage 
import homography


def image_in_image_affine(im1, im2, tp):
  """ Incrusta im1 en im2 haciendo una transformación afín a los puntos tp """

  f,c = im1.shape[:2]
  
  #puntos esquina de la imagen im1, a transformar a tp
  fp = pl.array([[0,0,c],
		 [0,f,f],
		 [1,1,1]])

  # se llama a H_from_points(tp, fp) en lugar de (fp,tp) por la foma que opera 
  # ndimage.affine_transform()
  H = homography.Haffine_from_points_DLT(tp, fp)
  
  # Usa la matriz A y el offset b para ir a buscar en im1 cada punto de warped_im1,
  # warped(i,j) = im1(A(i,j)+b(i,j))
  # de esta forma warped_im1 queda completa y los puntos de coordenadas decimales en im1
  # se determinan por interpolación 
  warped_im1 = ndimage.affine_transform(im1, H[:2,:2], (H[0,2],H[1,2]), im2.shape[:2])

  #incrusta warped_im1 en im2
  mascara = (warped_im1 > 0)*1

  return (1-mascara)*im2 + (mascara)*warped_im1

def image_in_image(im1, im2, tp):
  """ Incrusta im1 en im2 haciendo una transformación afín a los puntos tp """

  f,c = im1.shape[:2]
  
  #puntos esquina de la imagen im1, a transformar a tp
  fp = pl.array([[0,0,c,c],
		 [0,f,f,0],
		 [1,1,1,1]])

  # se llama a H_from_points(tp, fp) en lugar de (fp,tp) por la foma que opera 
  # ndimage.affine_transform()
  H = homography.H_from_points(tp, fp)

  # helper function for geometric_transform
  def mappfcn(x):
    x = pl.array([x[0],x[1],1])
    xt = pl.dot(H,x)
    xt = xt/xt[2]
    return xt[0],xt[1]
 
  # The given mapping function is used to find, for each point in the
  # output, the corresponding coordinates in the input. The value of the
  # input at those coordinates is determined by spline interpolation of
  # the requested order.
  warped_im1 = ndimage.geometric_transform(im1, mappfcn, im2.shape[:2])

  #incrusta warped_im1 en im2
  mascara = (warped_im1 > 0)*1

  return (1-mascara)*im2 + (mascara)*warped_im1

