
/// Maestría en Análisis y Procesamiento de Imágenes
///
/// Curso: Visión Robótica
///
/// Trabajo Práctico Nro. 2
///
///
/// Alumno:
///
/// Diciembre 2011       

#include <cv.h>
#include <highgui.h>
#include <iostream>

// prototipo de funciones
cv::Mat tile1x2( cv::Mat &im1, cv::Mat &im2 );

void match_l1( cv::Mat &d1, cv::Mat &d2, std::vector< cv::DMatch > &matches, float thr );
void match_ratio( cv::Mat &d1, cv::Mat &d2, std::vector< cv::DMatch > &matches, float thr1, float thr2 );

cv::Scalar red = cv::Scalar(0,0,255);
cv::Scalar green = cv::Scalar(0,255,0);
cv::Scalar blue = cv::Scalar(255,0,0);

// main
int main( int argc, char* argv[] )
{
  (void)argc;
  (void)argv;

  //---------------------------------
  //  Leer imágenes
  //---------------------------------

  // lee imágenes del disco
  //cv::Mat im1_rgb = cv::imread( "images/img1.ppm", -1 );
  //cv::Mat im2_rgb = cv::imread( "images/img1_rot30.ppm", -1 );
  cv::Mat im1_rgb = cv::imread( "images/img1_crop.ppm", -1 );
  cv::Mat im2_rgb = cv::imread( "images/img3.ppm", -1 );

  // cv::Mat im1_rgb = cv::imread( "images/t1_crop.jpg", -1 ); //objeto
  // cv::Mat im2_rgb = cv::imread( "images/t2.jpg", -1 ); //escena
  
  // convierte las imágenes a escala de grises
  cv::Mat im1_gray, im2_gray;
  cv::cvtColor( im1_rgb, im1_gray, CV_RGB2GRAY );
  cv::cvtColor( im2_rgb, im2_gray, CV_RGB2GRAY );  

  //convierte las imágenes a punto flotente
  cv::Mat im1, im2;
  im1_gray.convertTo( im1, CV_32F );
  im2_gray.convertTo( im2, CV_32F );

  // [0,255] -> [0,1]
  im1 *= (1.0/255.0);
  im2 *= (1.0/255.0);

  // visualiza imágenes RGB
  cv::Mat tile;
  tile = tile1x2( im1_rgb, im2_rgb );
  cv::imshow( "Imágenes", tile );

  //---------------------------------
  //  SIFT
  //---------------------------------

  //cv::SiftFeatureDetector detector( 0.2, 10.0 );
  cv::SiftFeatureDetector detector;

  std::vector<cv::KeyPoint> kp1, kp2;
  detector.detect( im1_gray, kp1 );
  detector.detect( im2_gray, kp2 );

  std::cout << kp1.size() << " puntos en im1" << std::endl;
  std::cout << kp2.size() << " puntos en im2" << std::endl;

  cv::SiftDescriptorExtractor extractor;

  cv::Mat d1, d2;
  extractor.compute( im1_gray, kp1, d1 );
  extractor.compute( im2_gray, kp2, d2 );

  //std::cout << d1.row(0) << std::endl;

  // visualiza SIFT
  cv::Mat im1_sift, im2_sift;
  cv::drawKeypoints( im1_rgb, kp1, im1_sift, green, 4 );
  cv::drawKeypoints( im2_rgb, kp2, im2_sift, green, 4 );
  tile = tile1x2( im1_sift, im2_sift );
  cv::imshow( "SIFT KeyPoints", tile );

  //---------------------------------
  // Matching
  //---------------------------------

  std::vector< cv::DMatch > matches;
  match_l1( d1, d2, matches, 2e3 );
  //match_ratio( d1, d2, matches, 2e3, 0.75 );

  std::cout << matches.size() << " matches" << std::endl;

  if( matches.size()==0 )
    return 0;

  // Visualiza matches
  cv::Mat im_matches;
  cv::drawMatches( im1_rgb, kp1, im2_rgb, kp2, matches, im_matches, green, green, std::vector<char>(), 0 );
  cv::imshow( "SIFT Matches", im_matches );


  //---------------------------------
  // Detección
  //---------------------------------
 
  std::vector<cv::Point2f> obj, scn;
  for( int i=0; i<(int)matches.size(); i++ )
  {
    obj.push_back( kp1[ matches[i].queryIdx ].pt );
    scn.push_back( kp2[ matches[i].trainIdx ].pt );
  }

  cv::Mat H = cv::findHomography( obj, scn, CV_RANSAC );

  // límites del objeto (imagen 1)
  std::vector<cv::Point2f> obj_corners(4);
  obj_corners[0] = cvPoint(0,0); 
  obj_corners[1] = cvPoint( im1.cols, 0 );
  obj_corners[2] = cvPoint( im1.cols, im1.rows ); 
  obj_corners[3] = cvPoint( 0, im1.rows );

  // proyección en la escena (imagen 2)
  std::vector<cv::Point2f> scn_corners(4);
  cv::perspectiveTransform( obj_corners, scn_corners, H);

  // visualiza objeto y los matches correspondientes
  cv::line( im2_rgb, scn_corners[0], scn_corners[1], blue, 4 );
  cv::line( im2_rgb, scn_corners[1], scn_corners[2], blue, 4 );
  cv::line( im2_rgb, scn_corners[2], scn_corners[3], blue, 4 );
  cv::line( im2_rgb, scn_corners[3], scn_corners[0], blue, 4 );

  std::vector<cv::KeyPoint> true_kp2;
  for( int i=0; i<(int)matches.size(); ++i ) 
  {
    true_kp2.push_back( kp2[matches[i].trainIdx] );
  }
  cv::drawKeypoints( im2_rgb, true_kp2, im2_rgb, blue, 4 );

  imshow( "Object", im2_rgb );

  // espera que se presiones una tecla
  std::cout << "\nPresione cualquier tecla para salir..." << std::endl;
  cv::waitKey(0);
  return 0;
}

//------------------------------------------------------------------------------------
// Matching usando umbral sobre norma L1

void match_l1( cv::Mat &d1, cv::Mat &d2, std::vector< cv::DMatch > &matches, float thr )
{
  assert( d1.cols==d2.cols );

  int n1 = d1.rows;
  int n2 = d2.rows;  

  matches.clear();

  for( int i=0; i<n1; ++i ) 
  {
    cv::Mat d_i = d1.row(i);

    for( int j=0; j<n2; ++j ) 
    {
      cv::Mat d_j = d2.row(j);

      float distance = cv::norm( d_i, d_j, cv::NORM_L1 );
      if( distance<=thr )
      {            
        cv::DMatch m_ij;
        m_ij.queryIdx = i;
        m_ij.trainIdx = j;
        m_ij.distance = distance;
        matches.push_back(m_ij);
      }

    }    
  }
}


//------------------------------------------------------------------------------------
// Matching usando umbral sobre la relación entre el primero y el segundo mejor

void match_ratio( cv::Mat &d1, cv::Mat &d2, std::vector< cv::DMatch > &matches, float thr1, float thr2 )
{
  assert( d1.cols==d2.cols );

  int n1 = d1.rows;
  int n2 = d2.rows;  

  matches.clear();

  for( int i=0; i<n1; ++i ) 
  {
    cv::Mat d_i = d1.row(i);

    float best1=HUGE, best2=HUGE;
    int idx1=-1;

    for( int j=0; j<n2; ++j ) 
    {
      cv::Mat d_j = d2.row(j);

      float distance = cv::norm( d_i, d_j, cv::NORM_L1 );

      if( distance<best1 )
      {
        best2 = best1;
        best1 = distance;
        idx1 = j;
      }
      else if( distance<best2 )
      {
        best2 = distance;
      }

    }      

    if( (best1<thr1) && (best1/best2<thr2) )
    {     
      cv::DMatch m_ij;
      m_ij.queryIdx = i;
      m_ij.trainIdx = idx1;
      m_ij.distance = best1;
      matches.push_back(m_ij);
    }

  }    

}

//------------------------------------------------------------------------------------

// Función que genera una imagen a partir de otras dos (lado a lado)
//
// Entrada:
//   im1: imagen 1 de alto H y ancho W1
//   im2: imagen 2 de alto H y ancho W2
//
// Salida:
//   imagen de alto H y ancho W1+W2

cv::Mat 
tile1x2( cv::Mat &im1, cv::Mat &im2 )
{
  assert( im1.type()==im2.type() );

  int H = std::max(im1.rows,im2.rows);
  int W1 = im1.cols;
  int W2 = im2.cols;

  cv::Mat tile( H, W1+W2, im1.type() );
  tile *= 0.0;

  cv::Mat r1 = cv::Mat( tile, cv::Rect(0,0,W1,im1.rows) );
  im1.copyTo( r1 );

  cv::Mat r2 = cv::Mat( tile, cv::Rect(W1,0,W2,im2.rows) );
  im2.copyTo( r2 );

  return tile;
}

